/*----------------------------------------------------------------------

  Prefs.c

  ----------------------------------------------------------------------

  Copyright (C). 2003 Smoky Monkey Factory All Rights Reserved
  http://andmore.jp/mobile/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: Prefs.c,v 1.4 2003/07/20 01:58:38 zxn Exp $

  ----------------------------------------------------------------------*/

#include <PalmOS.h>
#include "Prefs.h"
#include "SnapClip.h"
#include "Etc.h"

typedef struct 
{
  Boolean appEnabled;
  Boolean fldEnter;
  prefsAutoActivateIdx autoActivate;
} prefsType;

static void prefs_Init(prefsObj);

/*-----------------------------------------------------------------------
  new & delete
  -----------------------------------------------------------------------*/

prefsObj prefs_New(void)
{
  prefsObj prefs = (prefsObj)MemPtrNew(sizeof(prefsType));
  prefs_Init(prefs);
  return prefs;
}

void prefs_Delete(prefsObj prefs)
{
  MemPtrFree(prefs);
}

/*-----------------------------------------------------------------------
  prefsEnabled
  -----------------------------------------------------------------------*/

Boolean prefs_GetEnabled(prefsObj prefs)
{
  return ((prefsType *)prefs)->appEnabled;
}

void prefs_SetEnabled(prefsObj prefs, Boolean newVal)
{
  ((prefsType *)prefs)->appEnabled = newVal;
}

/*-----------------------------------------------------------------------
  auto activate after reset
  -----------------------------------------------------------------------*/

prefsAutoActivateIdx prefs_GetAutoActivate(prefsObj prefs)
{
  return ((prefsType *)prefs)->autoActivate;
}

void prefs_SetAutoActivate(prefsObj prefs, prefsAutoActivateIdx stat)
{
  ((prefsType *)prefs)->autoActivate = stat;
}


/*-----------------------------------------------------------------------
  prefsFldEnter
  -----------------------------------------------------------------------*/
void prefs_SetFldEnter(prefsObj prefs, Boolean newFldEnterStat)
{
  ((prefsType *)prefs)->fldEnter = newFldEnterStat;
}

Boolean prefs_GetFldEnter(prefsObj prefs)
{
  return ((prefsType *)prefs)->fldEnter;
}

void prefs_InitFldEnter(prefsObj prefs)
{
  ((prefsType *)prefs)->fldEnter = false;
}


/*-----------------------------------------------------------------------
  load prefs, or init it 
  -----------------------------------------------------------------------*/
static void prefs_Init(prefsObj prefs)
{
  if (PrefGetAppPreferencesV10(CREATOR_ID, 
			       PREF_VERSION, 
			       (void *)(prefs),
			       sizeof(prefsType)) == false) 
    {
      ((prefsType *)prefs)->appEnabled = false;
      ((prefsType *)prefs)->fldEnter = false;
      ((prefsType *)prefs)->autoActivate = PREFS_AUTO_ACTIVATE_NO;
    }
}

/*-----------------------------------------------------------------------
  save prefs
  -----------------------------------------------------------------------*/
void prefs_Save(prefsObj prefs)
{
  PrefSetAppPreferencesV10(CREATOR_ID, 
			   PREF_VERSION, 
			   (void *)prefs, 
			   sizeof(prefsType));
}

